Components.utils.import('resource://gre/modules/InlineSpellChecker.jsm');

//aldagai globalak
var InlineSpellCheckerUI = new InlineSpellChecker();
var prefLocaleListener = null;
var prefDictionaryListener = null;

// klase laguntzaileak
// OCR prozesurako begiralea
var OcrProccessObserver = {
    _outputfile: null,

    init: function(outputfile) {
        this._outputfile = outputfile;
    },
    observe: function(subject, topic, data) {
        if ('process-finished' == topic) {
            //prozesua ondo amaitu da.
            showStatusbar(false, '');

            if (this._outputfile) {
                var file = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
                file.initWithPath(this._outputfile);

                if (file.exists())
                    showFileInEditor(file);
                else
                    showErrorMessage('message.errorTitle', 'error.ocrNoResult');
            }
        }
        else if ('process-failed' == topic) {
            //prozesua errorearekin amaitu da.
            showStatusbar(false, '');
            setHtmlInEditor('');
            setEditorEditable(false);
            showErrorMessage('message.errorTitle', 'error.ocrFailed');
        }
    }
}

function PrefListener(branchName, func) {
    var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                        .getService(Components.interfaces.nsIPrefService);
    var branch = prefService.getBranch(branchName);
    branch.QueryInterface(Components.interfaces.nsIPrefBranch2);

    this.register = function() {
        branch.addObserver("", this, false);
        branch.getChildList("", { })
            .forEach(function (name) { func(branch, name); });
    };

    this.unregister = function unregister() {
        if (branch)
            branch.removeObserver("", this);
    };

    this.observe = function(subject, topic, data) {
        if (topic == "nsPref:changed") {
            func(branch, data);
        }
    };
}

//Interfazeko deiak
function initDialog() {
    var prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch2);
    var actualLocale = prefService.getCharPref('general.useragent.locale');

    prefLocaleListener = new PrefListener('general.useragent.locale',
        function(branch, name) {
            var prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch2);
            var selectedLocale = prefService.getCharPref('general.useragent.locale');
            
            if (actualLocale != selectedLocale) {
                //berrabiarazi egin behar da aplikazioa
                if (showConfirmMessage('message.warningTitle', 'warning.appNeedsRestart'))
                    restartApplication();
            }
        });
    prefLocaleListener.register();

    prefDictionaryListener = new PrefListener('spellchecker.dictionary',
        function(branch, name) {
            updateEditorDictionary(true);
        });
    prefDictionaryListener.register();
}

function toggleBold() {
    getEditor().contentDocument.execCommand('bold', false, null);
}

function toggleItalic() {
    getEditor().contentDocument.execCommand('italic', false, null);
}

function toggleUnderline() {
    getEditor().contentDocument.execCommand('underline', false, null);
}

function justifyLeft() {
    getEditor().contentDocument.execCommand('justifyLeft', false, null);
}

function justifyCenter() {
    getEditor().contentDocument.execCommand('justifyCenter', false, null);
}

function justifyRight() {
    getEditor().contentDocument.execCommand('justifyRight', false, null);
}

function removeFormat() {
    getEditor().contentDocument.execCommand('removeFormat', false, null);
}

function cut() {
    getEditor().contentDocument.execCommand('cut', false, null);
}

function copy() {
    getEditor().contentDocument.execCommand('copy', false, null);
}

function paste() {
    getEditor().contentDocument.execCommand('paste', false, null);
}

function undo() {
    getEditor().contentDocument.execCommand('undo', false, null);
}

function redo() {
    getEditor().contentDocument.execCommand('redo', false, null);
}

function showOptions() {
    var params = {out:null};
    window.openDialog("chrome://tesseractgui/content/options.xul", "options", "chrome,titlebar,toolbar,centerscreen,modal", params);

    // Linuxen ez du funtzionatzen (edo Gnome gainean behintzat), ez baitzaio ondialogaccept funtzioari deitzen.
    // Horregaitik egin behar izan da PrefListener horrekin.
    /*
    if (params.out) {
        if (params.out.uiLangChanged) {
            if (confirm("Zenbait aldaketek efektua izan dezaten aplikazioa berrabiarazi behar da. Orain egin nahi duzu?"))
                restartApplication();
        }

        var spellchecker = InlineSpellCheckerUI.mInlineSpellChecker.spellChecker;
        spellchecker.SetCurrentDictionary(params.out.dictionary);
        spellchecker.saveDefaultDictionary();
        InlineSpellCheckerUI.mInlineSpellChecker.spellCheckRange(null); // causes recheck
    }
    */
}

function ocrImage() {
    var image = selectImageFile();

    if (image) {
        writeLog('Aukeratutako irudia: ' + image.path);
        setEditorEditable(false);
        var outputFile = getTemporaryFile();
        writeLog('Fitxategi tenporala: ' + outputFile.path + '.html');
        orcImage2File(image.path, outputFile.path);
    }
    else {
        writeLog('Ez da fitxategirik aukeratu');
    }
}

function handleImageLoadingError() {
    document.getElementById('image').src = 'chrome://tesseractgui/content/images/error.gif';
}

function saveResult() {
    var outputFile = selectOutputFile();
    writeLog('Emaitza fitxategia: ' + outputFile ? outputFile.path : 'hutsa');

    if (outputFile)
        saveResult2File(outputFile);
}

function exitApplication() {
    var appStartup = Components.classes['@mozilla.org/toolkit/app-startup;1']
                        .getService(Components.interfaces.nsIAppStartup);
    appStartup.quit(Components.interfaces.nsIAppStartup.eAttemptQuit);
}

function openHelpFile() {
    Components.utils.import('resource://gre/modules/FileUtils.jsm');
    var file = FileUtils.getFile('AChrom', ['content', 'help', getMessage('file.helpFile')]);

    try {
        //Linuxetan ez omen dabil, horregatik try/catch bloketa:
        //https://developer.mozilla.org/en/XPCOM_Interface_Reference/nsILocalFile#Remarks
        //Soluzioa hemen proposaturikoa da:
        //http://mxr.mozilla.org/seamonkey/source/toolkit/mozapps/downloads/content/downloads.js
        file.launch();
    }
    catch(ex) {
        var uri = Components.classes['@mozilla.org/network/io-service;1']
                    .getService(Components.interfaces.nsIIOService).newFileURI(file);
        var protocolSvc = Components.classes['@mozilla.org/uriloader/external-protocol-service;1'].
                            getService(Components.interfaces.nsIExternalProtocolService);
        protocolSvc.loadUrl(uri);
        return;
    }
}

function initPopupMenu(event, popupMenu) {
    //Hemendik aterata:
    //http://mxr.mozilla.org/mozilla2.0/source/browser/base/content/nsContextMenu.js

    if (!isEditorEditable()) {
        event.preventDefault();
        return;
    }

    ////////////////////////////
    //nsContextMenu:setTarget hasiera
    initEditorSpellChecker();
    InlineSpellCheckerUI.initFromEvent(document.popupRangeParent, document.popupRangeOffset);
    //nsContextMenu:setTarget amaiera
    ////////////////////////////

    ////////////////////////////
    //nsContextMenu:initSpellingItems hasiera
    var canSpell = InlineSpellCheckerUI.canSpellCheck;
    var onMisspelling = InlineSpellCheckerUI.overMisspelling;

    // suggestion list
    showItem('spell-suggestions-separator', onMisspelling);

    if (onMisspelling) {
        var suggestionsSeparator = document.getElementById('spell-suggestions-separator');
        var numsug = InlineSpellCheckerUI.addSuggestionsToMenu(suggestionsSeparator.parentNode, suggestionsSeparator, 5);
        showItem('spell-no-suggestions', (numsug == 0));
    }
    else
        showItem('spell-no-suggestions', false);
    //nsContextMenu:initSpellingItems amaiera
    ////////////////////////////
}

//Funtzio laguntzaileak
function getEditor() {
    return document.getElementById('editFrame');
    //return document.getElementById('editEditor');
}

function writeLog(text) {
    var logCtrl = document.getElementById('log-text');

    if (logCtrl)
        logCtrl.value = logCtrl.value + text + '\n';
}

function getTemporaryFile() {
    var file = Components.classes['@mozilla.org/file/directory_service;1'].
                getService(Components.interfaces.nsIProperties).
                get('TmpD', Components.interfaces.nsIFile);
    file.append('tesseractguitmp');
    file.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0666);
    // do whatever you need to the created file
    return file;
}

function selectImageFile() {
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes['@mozilla.org/filepicker;1'].createInstance(nsIFilePicker);
    fp.init(window, getMessage('message.selectImageFile'), nsIFilePicker.modeOpen);
    fp.appendFilter(getMessage('message.filterImageFile'), '*.gif; *.jpeg; *.jpg; *.png; *.tif; *.tiff');

    var res = fp.show();

    if (res == nsIFilePicker.returnOK) {
        document.getElementById('image').src = filePath2Url(fp.file);
        return fp.file;
    }
    else {
        return null;
    }
}

function selectOutputFile() {
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes['@mozilla.org/filepicker;1'].createInstance(nsIFilePicker);
    fp.init(window, getMessage('message.saveFileAs'), nsIFilePicker.modeSave);
    fp.appendFilter(getMessage('message.filterHtmlFile'), '*.htm; *.html');
    
    var res = fp.show();
    
    if (res != nsIFilePicker.returnCancel) {
        writeLog('Erabiltzaileak aukeratutakoa: ' + fp.file.path);
        return fp.file;
    }
    else {
        return null;
    }
}

function orcImage2File(inputImage, outputHtml) {
    var prefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2);
    var tesseract = prefService.getCharPref("tesseractgui.tesseract.path");

    var file = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
    file.initWithPath(tesseract);

    if (!file.exists() || !file.isExecutable()) {
        showErrorMessage('message.errorTitle', 'error.tesseractNotFound');
        return;
    }
    
    var process = Components.classes['@mozilla.org/process/util;1'].createInstance(Components.interfaces.nsIProcess);
    process.init(file);

    var args = [inputImage, outputHtml, '-l', 'eus', 'hocr'];

    var tesseract_cmd = tesseract;
    for (var i = 0; i < args.length; i++)
        tesseract_cmd += ' ' + args[i];

    writeLog('Tesseract deia: ' + tesseract_cmd);
    showStatusbar(true, getMessage('message.ocrInExecution'));
    OcrProccessObserver.init(outputHtml + '.html');
    process.runwAsync(args, args.length, OcrProccessObserver);
}

function showFileInEditor(file) {
    //https://developer.mozilla.org/en/Code_snippets/File_I%2f%2fO
    Components.utils.import('resource://gre/modules/NetUtil.jsm');
    var channel = NetUtil.newChannel(file);
    //channel.contentCharset = 'utf-8';
    //channel.contentType = 'text/html';
    writeLog('Emaitza fitxategia irakurri: ' + file.path);
    NetUtil.asyncFetch(channel, function(inputStream, status) {
        writeLog('Irakurketa hasiera');

        if (!Components.isSuccessCode(status)) {
            // Handle error!
            showErrorMessage('message.errorTitle', 'error.ocrResultReadingFailed');
            return;
        }

        // The file data is contained within inputStream.
        // You can read it into a string with
        var data = NetUtil.readInputStreamToString(inputStream, inputStream.available());
        //data = data.replace('<head>', '<head><meta http-equiv="Content-Type" content="text/html;charset=utf-8" />');
        writeLog('Irakurketa amaiera');

        // Horrela egitea izango zen logikoena, baina ez dut lortu editagarri jartzea...
        //editor.src = filePath2Url(file);
        var utf8Converter = Components.classes['@mozilla.org/intl/utf8converterservice;1']
                                .getService(Components.interfaces.nsIUTF8ConverterService);
        setHtmlInEditor(utf8Converter.convertURISpecToUTF8 (data, 'UTF-8'));
        //beti en-US hartzen duelako lehenengo deian... 
        updateEditorDictionary(true);
        
        //TODO: agian fitxategia ezabatu beharko litzateke...
    });
}

function saveResult2File(file) {
    writeLog('Gorde hemen: ' + file.path);
    Components.utils.import('resource://gre/modules/NetUtil.jsm');
    Components.utils.import('resource://gre/modules/FileUtils.jsm');

    // You can also optionally pass a flags parameter here. It defaults to
    // FileUtils.MODE_WRONLY | FileUtils.MODE_CREATE | FileUtils.MODE_TRUNCATE;
    var ostream = FileUtils.openSafeFileOutputStream(file, FileUtils.MODE_WRONLY | FileUtils.MODE_CREATE | FileUtils.MODE_TRUNCATE);
    writeLog('Fitxategia sortu/ezabatu');
    var converter = Components.classes['@mozilla.org/intl/scriptableunicodeconverter'].
                        createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
    converter.charset = 'UTF-8';

    var istream = converter.convertToInputStream('<html>' + getEditor().contentWindow.document.documentElement.innerHTML + '</html>');

    // The last argument (the callback) is optional.
    NetUtil.asyncCopy(istream, ostream, function(status) {
        if (!Components.isSuccessCode(status)) {
            // Handle error!
            showErrorMessage('message.errorTitle', 'error.saveFileFailed');
            return;
        }
        // Data has been written to the file.
        writeLog('Fitxategia gorde da');
    });
}

function isEditorEditable() {
    return ('on' == getEditor().contentDocument.designMode);
}

function setEditorEditable(bEditable) {
    getEditor().contentDocument.designMode = bEditable ? 'on' : 'off';
}

function setHtmlInEditor(data) {
    setEditorEditable(true);
    var editor = getEditor();
    writeLog('Dena aukeratu');
    editor.contentDocument.execCommand('selectall', false, null);
    writeLog('html-a idatzi');
    editor.contentDocument.execCommand('inserthtml', false, data);
    writeLog('Editorean erakutsi');
}

function initEditorSpellChecker() {
    if (isEditorEditable()) {
        InlineSpellCheckerUI.clearSuggestionsFromMenu();
        InlineSpellCheckerUI.clearDictionaryListFromMenu();
        InlineSpellCheckerUI.uninit();

        var docShell = getEditor().docShell;
        docShell.QueryInterface(Components.interfaces.nsIEditorDocShell);
        InlineSpellCheckerUI.init(docShell.editor);
        updateEditorDictionary(false);
    }
}

function updateEditorDictionary(bRecheck) {
    writeLog('updateEditorDictionary(' + bRecheck + ')');
    
    if (isEditorEditable()) {
        if (!InlineSpellCheckerUI.mInlineSpellChecker)
            initEditorSpellChecker();

        var prefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2);
        var selectedDictionary = prefService.getCharPref("spellchecker.dictionary");
        
        //Txapuzatxoa: Hasierako deian en-US kargatzen du beti, eu erabili dezala jarriko dugu.
        if ('en-US' == selectedDictionary) {
            writeLog('selectedDictionary = ' + selectedDictionary);
            selectedDictionary = 'eu';
        }

        var spellchecker = InlineSpellCheckerUI.mInlineSpellChecker.spellChecker;
        writeLog('currentDictionary = ' + spellchecker.GetCurrentDictionary());
        
        if (spellchecker.GetCurrentDictionary() != selectedDictionary) {
            spellchecker.SetCurrentDictionary(selectedDictionary);
            spellchecker.saveDefaultDictionary();

            if (bRecheck)
                InlineSpellCheckerUI.mInlineSpellChecker.spellCheckRange(null); // causes recheck
        }
    }
}

function restartApplication() {

    //https://developer.mozilla.org/En/How_to_enable_locale_switching_in_a_XULRunner_application
	try {
        //Ez dirudi hau dena beharrezkoa denik
        /*
		// Which locale did the user select?
		var localeListbox = document.getElementById("locale-listbox");
		var newLocale = localeListbox.selectedItem.value;
		
		// Write preferred locale to local user config
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].
                    getService(Components.interfaces.nsIPrefBranch);
		prefs.setCharPref("general.useragent.locale", newLocale);
		*/
        
		// Restart application
		var appStartup = Components.classes["@mozilla.org/toolkit/app-startup;1"]
                            .getService(Components.interfaces.nsIAppStartup);

		appStartup.quit(Components.interfaces.nsIAppStartup.eRestart | Components.interfaces.nsIAppStartup.eAttemptQuit);
		
	} catch(err) {
	
		alert("Couldn't change locale: " + err);
	}
}

function showStatusbar(bShow, message) {
    var statusbar = document.getElementById('statusbar');

    if (statusbar)
        statusbar.label = message;

    showItem('progressbar', bShow);
}

function showItem(itemId, bShow) {
    var item = document.getElementById(itemId);
    if (item)
        item.hidden = !bShow;
}

function showErrorMessage(titleId, messageId) {
    //https://developer.mozilla.org/en/XPCOM_Interface_Reference/nsIPromptService
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                            .getService(Components.interfaces.nsIPromptService);
    promptService.alert(window, getMessage(titleId), getMessage(messageId));
}

function showConfirmMessage(titleId, messageId) {
    //https://developer.mozilla.org/en/XPCOM_Interface_Reference/nsIPromptService
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                            .getService(Components.interfaces.nsIPromptService);
    return promptService.confirm(window, getMessage(titleId), getMessage(messageId));
}

function getMessage(messageId) {
    var msgbundle = document.getElementById("messages");
    return msgbundle.getString(messageId);
}

function filePath2Url(file) {
    //https://developer.mozilla.org/en/Code_snippets/File_I%2f%2fO
    var ios = Components.classes['@mozilla.org/network/io-service;1'].getService(Components.interfaces.nsIIOService);
    return ios.newFileURI(file).spec;
}
